# PYTHON SCRIPT TO PLOT RELATIVE FATIGUE ESTIMATION ERRORS. COMPOSITE PANELS OF MULTIPLE FIGURES FOUND IN MANUSCRIPT HAVE BEEN CREATED EXTERNALLY.
# BY Lars Einar S. Stieng, 11.09.2018

# IMPORT PACKAGES.

import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker

# LOAD DATA.

folder = 'results_for_plotting/'

file_prefix = 'k_largest_est_extended_'

models = ['5percentless','5percentmore','5percentrnd','10percentless','10percentmore','10percentrnd','upto10percentrnd']

m = 6 # CHANGE THIS TO GENERATE THE PLOTS FOR EACH MODEL (0-6 in the order given above).

model = models[m] 

data = np.loadtxt(folder + file_prefix + model + '.txt')

# FIND MAXIMUM VALUE AMONG ALL LOCATIONS AND CHOOSE THIS LOCATION AS THE ONE TO PLOT.

mtb = np.max(np.abs(data[:,1]))
mtt = np.max(np.abs(data[:,2]))
mml = np.max(np.abs(data[:,3]))

loc = np.argmax([mtb,mtt,mml])+1

if (m == 5):
	loc = 3  #loc = 3 for 10rnd for consistency

y = data[:,loc] 

# SCATTER PLOT OF SAMPLE SET SIZE (COL 0) VS RELATIVE ERROR (COL loc). ALSO INDICATE TRUE VALUE (ZERO ERROR).

tb = plt.scatter(data[:,0],y,color='#1f78b4',marker='o',s=60,label='Estimates')
tru = plt.hlines(0.0,0.0,data[-1,0]+5,linestyles='dotted',colors='black',linewidth=2, label='True value')

plt.legend(handles=[tb,tru])

mname = ['MD5','MI5','MR5','MD10','MI10','MR10','MRU10']  # MODEL NAMES FOR USE IN TITLE

plt.title(mname[m],size=20)

plt.xlim([-0.1,data[-1,0]+5])

# CUSTOMIZE Y-LIM TO FIT THE DATA.
 
if (np.sum(y>0) == np.size(y)): # IF ALL DATA IS POSITIVE.
	miny = -np.max(y)
	maxy = np.max(y)*(1+0.2)
elif (np.sum(y<0) == np.size(y)): # IF ALL DATA IS NEGATIVE.
	miny = np.min(y)*(1+0.2)
	maxy = 0.1
else:
	miny = np.min(y)*(1+0.2)
	maxy = np.max(y)*(1+0.2)

factors1 = [0.05,1.0,1.0,0.15,1.0,100,1.0]	 #FACTOR SIZE (MODEL): 0.05 (5less), 1.0 (5more,5rnd,10more,upto10rnd), 0.15 (10less), 100 (10rnd).
factors2 = [1.0,0.15,0.2,1.0,0.15,1.0,0.2]   #FACTOR SIZE (MODEL): 1.0 (5less,10less,10rnd), 0.15 (5more,10more), 0.2 (5rnd,upto10rnd).

factor1 = factors1[m] 
factor2 = factors2[m]
	
plt.ylim([miny*(factor2),maxy*(factor1)]) 

plt.xticks([300,600,900,1200,1500,1800],['300','600','900','1200','1500','1800'],size=20)

# CHANGE FORMAT FOR Y-TICK-LABELS.

ax = plt.gca()

f = mticker.ScalarFormatter(useOffset=False, useMathText=True)
g = lambda t,pos : "${}$".format(f._formatSciNotation('%1.10e' % t))
h = lambda t,pos : "${}$".format(('%3i' % t))

ax.yaxis.set_major_formatter(mticker.FuncFormatter(g))
ax.xaxis.set_major_formatter(mticker.FuncFormatter(h))

plt.yticks(size=20)

plt.minorticks_on()
plt.tick_params(width=5,length=5)
plt.tick_params(which='minor',width=2,length=5)

# DON'T PLOT TICKS ON RIGHT SIDE. DON'T PLOT ANY TICKS FOR X-VALUES.

ax.yaxis.set_ticks_position('left')

ax.tick_params(
    axis='x',          
    which='both',      
    top='off')
    

plt.ylabel('Relative error ($\delta$)',size=20)
plt.xlabel('Sampling set size ($n$)',size=20)

# MAKE EXTRA SPACE AROUND AXIS LABELS.

t = ax.yaxis.get_offset_text()
t.set_size(20)

plt.gcf().subplots_adjust(left=0.25)
plt.gcf().subplots_adjust(bottom=0.15)

# SHOW PLOT OR SAVE AS PDF.


#plt.show()

plt.savefig(file_prefix + model + '.pdf',format='pdf')