# PYTHON SCRIPT TO PLOT SIZE OF SAMPLE SET VS NUMBER OF LOAD CASES SAMPLED PER LOCATION. COMPOSITE PANELS OF MULTIPLE FIGURES FOUND IN MANUSCRIPT HAVE BEEN CREATED EXTERNALLY.
# BY Lars Einar S. Stieng, 14.05.2018 (Updated 11.09.2018)

# IMPORT PACKAGES.

import numpy as np
import matplotlib.pyplot as plt

	
# LOAD DATA FOR EACH LOCATION.

folder = 'results_for_plotting/'

data1 = np.loadtxt(folder + 'tb_fatigue_8points_base_model.txt')
data2 = np.loadtxt(folder + 'ml_fatigue_8points_base_model.txt')
data3 = np.loadtxt(folder + 'tt_fatigue_8points_base_model.txt')

# SORT DATA IN DESCENDING ORDER.

y1 = np.argsort(data1)[::-1]
y2 = np.argsort(data2)[::-1]
y3 = np.argsort(data3)[::-1]

# FIND UNION OF i MOST SEVERE LOAD CASES FOR EACH LOCATION FOR i from 1 to N. ALSO SAVE SIZE OF THE UNION FOR EACH i.

N = 150

union_lens = np.zeros(N)

for i in range(0,N):

	un_ = np.union1d(y1[0:i+1],y2[0:i+1])
	un = np.union1d(un_,y3[0:i+1])
	union_lens[i] = np.size(un)

# LINE PLOT, WTIH SPECIFIED LIMITS AND TICK LOCATIONS/SIZES AND TICK-LABEL SIZES.
	
plt.plot(range(1,N+1),union_lens,color='#1f78b4',linewidth=3)

ax = plt.gca()

plt.xlim([-0.1,155])

plt.ylim([-1,190])

plt.xticks([20,40,60,80,100,120,140],['20','40','60','80','100','120','140'],size=20)
plt.yticks([20,40,60,80,100,120,140,160,180],['20','40','60','80','100','120','140','160','180'],size=20)

plt.minorticks_on()
plt.tick_params(width=5,length=5)
plt.tick_params(which='minor',width=2,length=5)

# CHANGE LOCATION OF TICKS.

ax.yaxis.set_ticks_position('left')

ax.tick_params(
    axis='x',          
    which='both',      
    top='off')
    

plt.ylabel('Sampling set size ($n$)',size=20)
plt.xlabel('Sampled load cases per location ($k$)',size=20)

# MAKE EXTRA SPACE AROUND AXIS LABELS.

t = ax.yaxis.get_offset_text()
t.set_size(20)

plt.gcf().subplots_adjust(left=0.20)
plt.gcf().subplots_adjust(bottom=0.15)

# SHOW PLOT OR SAVE AS PDF.

#plt.show()

plt.savefig('union_size.pdf',format='pdf')