# PYTHON SCRIPT TO PLOT THE FATIGUE DISTRIBUTION. COMPOSITE PANELS OF MULTIPLE FIGURES FOUND IN MANUSCRIPT HAVE BEEN CREATED EXTERNALLY.
# BY Lars Einar S. Stieng, 14.05.2018 (Updated 11.09.2018)

# IMPORT PACKAGES.

import numpy as np
import matplotlib.pyplot as plt

# LOAD DATA.

data = np.loadtxt('results_for_plotting/tb_fatigue_8points_base_model.txt')

# NORMALIZE BY SUM OF DATA TO MAKE INTO PROBABILITY DISTRIBUTION.

y = data/np.sum(data)

# NORMALIZE BY MAXIMUM FOR CLARITY.

y = y/np.max(y)

# CREATE VECTOR REPRESENTING THE LOAD CASES.

x = np.linspace(1,np.size(y),np.size(y))

# CREATE VECTOR REPRESENTING THE LOAD CASES SORTED BY SEVERITY.

inds = np.argsort(y)

# EXTRACT THE 25 MOST SEVERE LOAD CASES.

mask = np.ones(3647,dtype=bool)

mask[inds[-25:]] = False

x1 = x[mask]

x2 = x[inds[-25:]]

yless = y[mask]
yrest = y[inds[-25:]]

# PLOT THE DISTRIBUTION EXCEPT THE 25 MOST SEVERE POINTS. THEN PLOT ONLY THESE POINTS WITH NEW SYMBOL AND COLOR AND WITH LARGER MARKER SIZE. USE LOG SCALE.

rest = plt.scatter(x1,yless,color='#1f78b4',marker='.',s=30,label='Severity per load case')
peaks = plt.scatter(x2,yrest,color='#33a02c',marker='x',s=60,label='25 most severe load cases')
	
ax = plt.gca()
ax.set_yscale('log')

# ALSO PLOT DOTTET LINES SEPARATING THE DIFFERENT WIND SPEED BINS

xval = [504.5,1008.5,1448.5,1917.5,2361.5,2713.5,3083.5,3307.5,3475.5,3605.5]

lines = plt.vlines(xval,-10,1,linestyles='dotted',colors='red',linewidth=2, label='Bin separators')	

plt.legend(handles=[rest,peaks,lines],loc=(0.004,0.81),fontsize='medium')

# SET AXES AND TICKS. NO TICKS ON X-AXIS. SET X- AND Y-LABELS.

plt.xlim([-100,np.size(y)+100])

plt.ylim([10**(-10),10**(3)])

plt.xticks([252,756,1248,1702,2139,2537,2898,3391,3626+50],['4','6','8','10','12','14','16','20','24'],size=20)

plt.yticks([10**(-8),10**(-6),10**(-4),10**(-2),10**0],[r"$10^{-8}$",r"$10^{-6}$",r"$10^{-4}$",r"$10^{-2}$",r"$10^{0}$"],size=20)


plt.tick_params(width=2.5,length=5)
plt.tick_params(axis='y',which='minor',width=1,length=5)

ax.yaxis.set_ticks_position('left')

plt.tick_params(
    axis='x',          
    which='both',            
    top=False)
    

plt.ylabel('Normalized severity',size=20)
plt.xlabel('Wind speed bins [m/s]',size=20)

# CREATE X-AXIS ON TOP TO BETTER DELINEATE BETWEEN THE LAST FEW BINS

axtop = ax.twiny()

axtop.set_xticks([3195,3540])
axtop.set_xticklabels(['18','22'],size=20)

axtop.set_xlim([-100,np.size(y)+100])

axtop.tick_params(width=2.5,length=5)

# MAKE EXTRA SPACE AROUND AXIS LABELS.

t = ax.yaxis.get_offset_text()
t.set_size(20)

plt.gcf().subplots_adjust(left=0.20)
plt.gcf().subplots_adjust(bottom=0.15)

# SHOW PLOT OR SAVE AS PDF.

#plt.show()

plt.savefig('fatigue_damage_dist_with_mask_new.pdf',format='pdf')
