# PYTHON SCRIPT TO PLOT HEATMAPS OF RELATIVE FATIGUE ERRORS. COMPOSITE PANELS OF MULTIPLE FIGURES FOUND IN MANUSCRIPT HAVE BEEN CREATED EXTERNALLY.
# BY Lars Einar S. Stieng, 14.05.2018 (Updated 11.09.2018)

# IMPORT PACKAGES.

import numpy as np
import matplotlib.pyplot as plt
import seaborn as sb


# LOAD DATA.

data = np.loadtxt('results_for_plotting/errors_tb_extended.txt')

# SELECT WHICH VALUES OF 'k' (NUMER OF LOAD CASES IN SAMPLE) TO USE.

mask = np.zeros(np.size(data[0,:]),dtype=bool)

mask[0] = 1
mask[2] = 1
mask[10] = 1
mask[33] = 1
mask[78] = 1
mask[147] = 1
mask[148] = 1
mask[149] = 1

use_data = np.abs(data[:,mask])

# CALCULATE RELATIVE DIFFERENCES BETWEEN ESTIMATION ERROR FOR BASE DESIGN AND ESTIMATION ERRORS FOR EACH MODIFIED DESIGN AND EACH VALUE OF 'k'. 

for i in range(np.size(use_data[0,:])):

	use_data[:,i] = 1 - use_data[:,i]/use_data[0,i]

# PREPARE DATA FOR PLOTTING. DON'T PLOT DATA FOR BASE DESIGN, SINCE THIS IS OBVIOUSLY ZERO.	
	
plot_data_tb = np.abs(use_data.transpose())
annot_data_tb = np.abs(data[:,mask]).transpose()
# REPEAT FOR TWO OTHER LOCATIONS.

data = np.loadtxt('results_for_plotting/errors_tt_extended.txt')

use_data = np.abs(data[:,mask])

for i in range(np.size(use_data[0,:])):

	use_data[:,i] = 1 - use_data[:,i]/use_data[0,i]

plot_data_tt = np.abs(use_data[0:,:].transpose())
annot_data_tt = np.abs(data[:,mask]).transpose()
data = np.loadtxt('results_for_plotting/errors_ml_extended.txt')

use_data = np.abs(data[:,mask])

for i in range(np.size(use_data[0,:])):

	use_data[:,i] = 1 - use_data[:,i]/use_data[0,i]

plot_data_ml = np.abs(use_data[0:,:].transpose())
annot_data_ml = np.abs(data[:,mask]).transpose()
# SETUP FOR PLOTTING

ticksize = 13
labelsize = 20

cm = plt.cm.get_cmap('Blues')

# PLOT HEATMAPS, SET TICK-LABELS AND AXIS-LABELS AND MAKE SOME SPACE FOR AXIS LABEL AND THEN SAVE AS PDF.

axn = sb.heatmap(plot_data_tb,linewidths=0.1,cmap=cm,cbar=1,annot=annot_data_tb,vmin=0,vmax=0.35)
axn.set_xticklabels(['Base','MD5','MI5','MR5','MD10','MI10','MR10','MRU10'],size=ticksize)
axn.set_yticklabels(['5','10','20','50','100','200','500','1000'],size=ticksize)

axn.set_ylabel('Number of load cases',size=labelsize)
axn.set_xlabel('Design',size=labelsize)

plt.title('Tower bottom',size=20)

plt.gcf().subplots_adjust(bottom=0.15)
plt.savefig('heatmap_tb_extended.pdf',format='pdf')
plt.clf()

# REPEAT FOR TWO OTHER LOCATIONS.

axn1 = sb.heatmap(plot_data_tt,linewidths=0.1,cmap=cm,cbar=1,annot=annot_data_tt,vmin=0,vmax=0.35)
axn1.set_xticklabels(['Base','MD5','MI5','MR5','MD10','MI10','MR10','MRU10'],size=ticksize)
axn1.set_yticklabels(['5','10','20','50','100','200','500','1000'],size=ticksize)

axn1.set_ylabel('Number of load cases',size=labelsize)
axn1.set_xlabel('Design',size=labelsize)

plt.title('Tower top',size=20)

plt.gcf().subplots_adjust(bottom=0.15)
plt.savefig('heatmap_tt_extended.pdf',format='pdf')
plt.clf()

axn2 = sb.heatmap(plot_data_ml,linewidths=0.1,cmap=cm,annot=annot_data_ml,vmin=0,vmax=0.35)

axn2.set_xticklabels(['Base','MD5','MI5','MR5','MD10','MI10','MR10','MRU10'],size=ticksize)
axn2.set_yticklabels(['5','10','20','50','100','200','500','1000'],size=ticksize)

axn2.set_ylabel('Number of load cases',size=labelsize)
axn2.set_xlabel('Design',size=labelsize)

plt.title('Mudline',size=20)

# MAKE EXTRA SPACE AROUND AXIS LABELS.

plt.gcf().subplots_adjust(bottom=0.15)

# SHOW PLOT OR SAVE AS PDF.

#plt.show()

plt.savefig('heatmap_ml_extended.pdf',format='pdf')

