# PYTHON SCRIPT TO PLOT PARTIAL FATIGUE DAMAGE SUMS VS NUMBER OF LOAD CASES USED.
# BY Lars Einar S. Stieng, 14.05.2018 (Updated 11.09.2018)

# IMPORT PACKAGES.

import numpy as np
import matplotlib.pyplot as plt

	
# LOAD DATA.

folder = 'results_for_plotting/'

data = np.loadtxt(folder + 'tb_fatigue_8points_base_model.txt')

# GET NORMALIZATION FACTOR.

norm = np.sum(data)

# SORT DATA IN DESCENDING ORDER.

y1 = np.sort(data)[::-1]

# DEFINE X-VALUES AS FRACTION OF LOAD CASES USED

x = np.linspace(1/np.size(y1),1,np.size(y1))

# CALCULATE NORMALIZED PARTIAL SUMS

y3 = np.zeros(np.size(y1))

for i in range(0,np.size(y1)):
	y3[i] = np.sum(y1[0:i+1])/norm

# PLOT FIRST 1000 PARTIAL SUMS AND INCLUDE INDICATION OF TOTAL SUM.	
	
plt.plot(x[0:999],y3[0:999],color='#1f78b4',linewidth=3)
plt.hlines(1.0,0.0,0.27,linestyles='dotted',colors='black',linewidth=2)
ax = plt.gca()

# SPECIFY LIMITS AND TICK LOCATIONS/SIZES AND TICK-LABEL SIZES.

plt.xlim([-0.005,0.27])

plt.ylim([-0.05,1.1])

plt.xticks([0.05,0.1,0.15,0.2,0.25],['0.05','0.1','0.15','0.2','0.25'],size=20)
plt.yticks([0,0.2,0.4,0.6,0.8,1.0],['0','0.2','0.4','0.6','0.8','1.0'],size=20)

plt.minorticks_on()
plt.tick_params(width=5,length=5)
plt.tick_params(which='minor',width=2,length=5)

# CHANGE LOCATION OF TICKS.

ax.yaxis.set_ticks_position('left')

ax.tick_params(
    axis='x',          
    which='both',      
    top='off')
    

plt.ylabel(r"$D_k/D_{\mathrm{tot}}$",size=20)
plt.xlabel(r"$k/3647$",size=20)

# MAKE EXTRA SPACE AROUND AXIS LABELS.

t = ax.yaxis.get_offset_text()
t.set_size(20)

plt.gcf().subplots_adjust(left=0.20)
plt.gcf().subplots_adjust(bottom=0.15)

# SHOW PLOT OR SAVE AS PDF.

#plt.show()

plt.savefig('partial_sums_new.pdf',format='pdf')